package de.aoj.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import de.aoj.core.IAspect.Instantiation;

public class Aspects {
    
    private static final Aspects root = new Aspects();
    private static final List global = new ArrayList();
    private static final Map perJVM = new HashMap();
    
    private final Map aspects = new HashMap();

    private Aspects() { }
    
    static Aspects of(Class entity) {
        if (entity == null) return root;
        
        Aspects aspects = aspectsForClass(entity);
        return aspects == null ? root : aspects;
    }

    public static Aspects forMe() { 
        return new Aspects(); 
    }

    public static void register(Class aspect, Class impl) {
        root.define(aspect, impl);
    }

    public static void global(Class aspect) {
        if (!global.contains(aspect)) global.add(aspect);
    }
    
    public Aspects define(Class aspect, Class impl) {
        if (!(aspect.isAssignableFrom(impl))) throw new IllegalArgumentException("Class " + impl + " is not an instance of " + aspect);
        aspects.put(aspect, impl);
        return this;
    }

    public List createAspects(Class entity) {
        List result = new ArrayList();
        
        List interfaces = new ArrayList(global);
        interfaces.addAll(Arrays.asList(entity.getInterfaces()));
        for (Iterator iter = interfaces.iterator(); iter.hasNext();) {
            Class interf = (Class) iter.next();
            if (IAspect.class.isAssignableFrom(interf)) 
                result.add(createAspect(entity, interf));
        }
        return result;
    }
    
    private IAspect createAspect(Class entity, Class aspect) {
        Class impl = null;
        
        impl = (Class) aspects.get(aspect);
        if (impl == null) {
            if (entity == null) throw new IllegalArgumentException("No implementation found for class=" + aspect);
            return Aspects.of(entity.getSuperclass()).createAspect(entity, aspect);
        }
        return createInstance(aspect, impl);
    }
    
    private IAspect createInstance(Class aspect, Class impl) {
        try {
            IAspect.Instantiation type = typeForClass(aspect);
            if (type == IAspect.PerJVM) {
                IAspect result = (IAspect) perJVM.get(aspect);
                if (result == null) {
                    result = (IAspect) impl.newInstance();
                    perJVM.put(aspect, result);
                }
                return result;
            }
            return (IAspect) impl.newInstance();
        } catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Instantiation typeForClass(Class impl) {
        try {
            return (Instantiation) impl.getField("TYPE").get(impl);
        } catch (NoSuchFieldException e) {
            return IAspect.PerEntity;
        } catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
    
    private static Aspects aspectsForClass(Class entity) {
        try {
            return (Aspects) entity.getField("LOCAL").get(entity);
        } catch (NoSuchFieldException e) {
            return null;
        } catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

}