package de.aoj.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class EntityFactory {
    private static class Dispatcher implements InvocationHandler {
        private final List members;
        
        private Dispatcher(Class entity, IModel model) {
            members = new ArrayList();
            members.add(model);
            members.addAll( Aspects.of(entity).createAspects(entity) );
        }
        
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object member = lookupMemberThatContainsTheMethod(this.members, m);
            Invocation ctx = new Invocation(m, args, this.members, member, proxy);
            try {
                return ctx.proceed();
            } finally {
                ctx.restore();
            }
    	}
    
    	private Object lookupMemberThatContainsTheMethod(List members, Method m) throws NoSuchMethodException {
            for (Iterator i = members.iterator(); i.hasNext();) {
                Object member = i.next();
                try {
                    member.getClass().getMethod(m.getName(), m.getParameterTypes());
                    return member;
                } catch (NoSuchMethodException e) {
                    continue;
                }
            }
    	    throw new NoSuchMethodException("Method " + m + " not found");
    	}
    }
    public static Object create(Class entity, IModel model) {
        Dispatcher result = new Dispatcher(entity, model);
        return Proxy.newProxyInstance(model.getClass().getClassLoader(), new Class[] { entity }, result);
    }
}
