package de.aoj.example1;

import de.aoj.core.Aspects;
import de.aoj.core.EntityFactory;
import de.aoj.core.IModel;
import de.aoj.system.IValidationAspect;
import de.aoj.system.ValidationAspect;

public class OrderPosition {
        
    static {
        Aspects.register(IValidationAspect.class, OrderPositionValidationAspect.class);
    }
    
    public interface Entity extends IOrderPositionModel, IValidationAspect {}
    
    public static OrderPosition.Entity entity() {
        return (OrderPosition.Entity) EntityFactory.create(OrderPosition.Entity.class, new OrderPosition.Model());
    }
    
    public interface IOrderPositionModel extends IModel {
        int getQuantity();
        void setQuantity(int quantity);
    }
    
    public static class Model implements IOrderPositionModel {

        private int quantity;
        
        public int getQuantity() {
            return quantity;
        }
        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }
    }

    public static class OrderPositionValidationAspect extends ValidationAspect {

        public boolean validate(IModel model) {
            if (!(model instanceof IOrderPositionModel)) throw new IllegalArgumentException();
            
            return ( ((IOrderPositionModel) model).getQuantity() > 0 );
        }
    }
}
