package de.aoj.example3;

import java.util.Date;
import java.util.Iterator;

import de.aoj.core.Aspects;

public class Main {
    
    private static final String user = "Scott";

    public static void main(String[] args) {
        Aspects.register(IStandardAttributesAspect.class, StandardAttributesAspect.class);
        
        Order.Entity order = createOrder();

        order.addPosition(createOrderPosition(order, 2));
        order.addPosition(createOrderPosition(order, 7));
        
        displayOrder(order);
    }

    private static Order.Entity createOrder() {
        Order.Entity result = Order.entity();
        initStandardAttributes(result);
        return result;
    }

    private static OrderPosition.Entity createOrderPosition(Order.Entity order, int quantity) {
        OrderPosition.Entity result = OrderPosition.entity(order);
        result.setQuantity(quantity);
        initStandardAttributes(result);
        return result;
    }

    private static void initStandardAttributes(IStandardAttributesAspect result) {
        result.setCreationUser(user);
        result.setCreationDate(new Date());
    }

    private static void displayOrder(Order.Entity order) {
        System.out.println("Display order:");
        System.out.println("Order id: " + order.getId());
        System.out.println("Creation user: " + order.getCreationUser());
        System.out.println("Creation date: " + order.getCreationDate());
        for (Iterator iter = order.getPositions().iterator(); iter.hasNext();) {
            displayOrderPosition((OrderPosition.Entity) iter.next());
        }
    }

    private static void displayOrderPosition(OrderPosition.Entity position) {
        System.out.println("Display position:");
        System.out.println("Creation user: " + position.getCreationUser());
        System.out.println("Creation date: " + position.getCreationDate());
        System.out.println("Quantity: " + position.getQuantity());
    }

}
