package de.aoj.example3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import de.aoj.core.Aspects;
import de.aoj.core.EntityFactory;
import de.aoj.core.IModel;
import de.aoj.system.IValidationAspect;
import de.aoj.system.ValidationAspect;

public class Order {
    
    public interface Entity extends IOrderModel, IValidationAspect, IStandardAttributesAspect {
        Aspects LOCAL = Aspects.forMe().define(IValidationAspect.class, OrderValidationAspect.class);
    }

    public static Order.Entity entity() {
        return (Order.Entity) EntityFactory.create(Order.Entity.class, new Order.Model());
    }

    public interface IOrderModel extends IModel {
        Long getId();
        List getPositions();
        void addPosition(OrderPosition.Entity position);
    }
    
    public static class Model implements IOrderModel {
        private static long counter = 0;
        
        private final Long id;
        private List positions;
        
        public Model() {
            this.id = new Long(++counter);
            this.positions = new ArrayList();
        }
        public Long getId() {
            return id;
        }
        public List getPositions() {
            return positions;
        }
        public void addPosition(OrderPosition.Entity position) {
            this.positions.add(position);
        }
    }
    
    public static class OrderValidationAspect extends ValidationAspect {
        
        public boolean validate(IModel model) {
            boolean result = true;
            
            if (!(model instanceof IOrderModel)) throw new IllegalArgumentException();
            
            for (Iterator iter = ((IOrderModel) model).getPositions().iterator(); iter.hasNext() && result;) {
                OrderPosition.Entity pos = (OrderPosition.Entity) iter.next();
                result = pos.isValid();
            }
            
            return result;
        }
    }

}
