package de.aoj.internal.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;
import de.aoj.core.Aspects;
import de.aoj.core.EntityFactory;
import de.aoj.core.Invocation;
import de.aoj.system.ILoggingAspect;

/**
 * @author via
 *
 * @version $Id$
 */
public class CoolTest2 extends TestCase {
    protected void setUp() throws Exception {
        Aspects.register(ILoggingAspect.class, ILoggingAspect.Default.class);
        Aspects.register(Test2.ITestAspect.class, Test2.TestAspect.class);
        Aspects.register(Test2.ITestMixin.class, Test2.TestMixin.class);
        Aspects.register(Test2.CounterAspect.class, Test2.CounterAspect.class);
        
        Aspects.global(ILoggingAspect.class);
        Aspects.global(Test2.CounterAspect.class);
    }
    
    public void testGlobal() {
        System.out.println("testGlobal");
        Test2.Entity entity = (de.aoj.internal.test.Test2.Entity) EntityFactory.create(Test2.Entity.class, new Test2.ModelImpl());
        assertTrue(Invocation.current() == null);
        Test2.CounterAspect.start();
        entity.getMamma();
        assertTrue(Test2.CounterAspect.count() == 1);
        assertTrue(Invocation.current() == null);
    }
    
    public void testCallModelMethod() {
        System.out.println("testCallModelMethod");
        Test2.Entity entity = (de.aoj.internal.test.Test2.Entity) EntityFactory.create(Test2.Entity.class, new Test2.ModelImpl());
        String text = "testtestbla";
        
        Test2.CounterAspect.start();
        entity.setMamma(text);
        String text2 = entity.getMamma();
        String text3 = entity.doStuff();
        assertEquals(text, text2);
        assertEquals("Model:" + text, text3);
        assertEquals(Test2.CounterAspect.count(), 3);
    }
    
    public void testCallAspectMethod() {
        System.out.println("testCallAspectMethod");
        Test2.Entity entity = (de.aoj.internal.test.Test2.Entity) EntityFactory.create(Test2.Entity.class, new Test2.ModelImpl());
        String text = "testtestbla";
        
        Test2.CounterAspect.start();
        String text2 = entity.callAspectMethod(text);
        assertEquals("Aspect:" + text, text2);
        assertTrue(Test2.CounterAspect.count() == 1);
    }
    
    public void testToString() {
        System.out.println("testToString");
        Test2.Entity entity = (de.aoj.internal.test.Test2.Entity) EntityFactory.create(Test2.Entity.class, new Test2.ModelImpl());
        String text = "testtestbla";
        
        Test2.CounterAspect.start();
        entity.setMamma("model");
        entity.setMixinValue("mixin");
        String text2 = entity.toString();
        System.out.println(text2);
        assertTrue(text2.indexOf("model") != -1);
        assertFalse(text2.indexOf("mixin") != -1); // Dieser Test zeigt, dass toString nicht funktioniert wie erwartet.
        assertEquals(Test2.CounterAspect.count(), 3);
    }
    
    public void testEquals() {
        System.out.println("testEquals");
        Test2.Entity e1 = (de.aoj.internal.test.Test2.Entity) EntityFactory.create(Test2.Entity.class, new Test2.ModelImpl());
        Test2.Entity e2 = (de.aoj.internal.test.Test2.Entity) EntityFactory.create(Test2.Entity.class, new Test2.ModelImpl());
        
        e1.setMamma("mamma1");
        e2.setMamma("mamma1");
        
        assertEquals(e1, e2);
        
        e2.setMamma("lallo");
        assertFalse(e1.equals(e2));
        
        e1.setMamma("lallo");
        e2.setMixinValue("sessu");
        assertTrue(e1.equals(e2)); // Dieser Test zeigt, dass equals nicht funktioniert wie erwartet.
        
        e1.setMixinValue("sessu");
        assertTrue(e1.equals(e2));
    }
    
    public void testMap() {
        C c1 = new C("mamma");
        C c2 = new C("lallo");
        
        assertFalse(c1.equals(c2));
        List list = new ArrayList();
        list.add(c1);
        assertFalse(list.contains(c2));
        assertTrue(list.contains(c1));
        
        Map map = new HashMap();
        map.put(c1, c2);
        assertFalse(map.containsKey(c2));
        assertTrue(map.containsValue(c2));
    }
    
    private static class C {
        String s;
        C(String s) { this.s = s; }
        public int hashCode() {
            return 10;
        }
    }
}
