package de.aoj.internal.test.validation;

import junit.framework.TestCase;
import de.aoj.core.EntityFactory;

public class ValidationAspectTest extends TestCase {
    
    public void testValidationAspect1() {
        Order.Entity order = 
            (Order.Entity) EntityFactory.create(Order.Entity.class, new Order.Model());
        OrderPosition.Entity position = 
            (OrderPosition.Entity) EntityFactory.create(OrderPosition.Entity.class, new OrderPosition.Model());

        position.setOrder(order);
        position.setQuantity(2);
        
        order.addPosition(position);

        assertTrue(order.isValid());
        
    }
    
    public void testValidationAspect2() {
        Order.Entity order = 
            (Order.Entity) EntityFactory.create(Order.Entity.class, new Order.Model());
        OrderPosition.Entity position = 
            (OrderPosition.Entity) EntityFactory.create(OrderPosition.Entity.class, new OrderPosition.Model());
        
        position.setOrder(order);
        position.setQuantity(0);
        
        order.addPosition(position);

        assertFalse(order.isValid());
    }
    
}
