package de.aoj.system;

import de.aoj.core.IModel;
import de.aoj.core.Invocation;


public abstract class ValidationAspect implements IValidationAspect {
    
    private boolean isValid = false;

    public abstract boolean validate(IModel model);

    public boolean isValid() {
        return isValid;
    }

    public Object intercept(Invocation ctx) throws Throwable {
        try {
            return ctx.proceed();
        } finally {
            isValid = validate(ctx.model);
        }
    }

}
