/*
  struct.c
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>

#include "struct.h"
#include "var.h"
#include "p97.h"
#include "garb.h"



static struct tab_t {
  char pub[NAME_L + 1], priv[NAME_L + 1];
} tab[VAR_N];

typedef struct tab_t TAB;

char *inputp;        /* contatore per mystrtok */
static TAB *tabp = tab;     /* tabp punta al primo vuoto */


/*

 Esempio di tabella:

          --------------
          |pub  |  priv|
          --------------
  tab  -->| X   | X_000|
          | Y   | X_001|
          | Res | X_002|
          | Acc | X_003|
  tabp -->|     |      |
          |     |      |
          |     |      |
          --------------

*/


static int isatomic(void);
static void dolist(OBJ *that);
static void reset_tab( void );
static TAB *in_tab(char *s);
static char *add_tab(char *s);


void create_cl(char *s, CLAUSE *cl)
{
  char *p, *p2;

  if ((p = strstr(s, " :- ")) != NULL) {
    p2 = p + 4;
    *p = '\0';
    cl->head = alloc_obj();
    cl->body = alloc_obj();
    create_head(s, cl->head);
    create_goal(p2, cl->body);
  } else {
    cl->head = alloc_obj();
    create_head(s, cl->head);
    cl->body = NULL;
  }
}


void create_goal(char *s, OBJ *st)
{
  static char buf[LINE_L + 1];

  strcpy(buf, "dummy ( ");
  strcat(buf, s);
  strcat(buf, " )");

  inputp = buf;
  st->brother = NULL;
  dolist(st);
}


void create_head(char *s, OBJ *st)
{
  inputp = s;
  st->brother = NULL;
  dolist(st);
}


int isconst_st(OBJ *p)
{
  return (isatom_st(p) && !isvar(getobj(p)->name));
}


int isatom_st(OBJ *p)
{
  return (getobj(p)->arity == 0);
}


int isvar_st(OBJ *p)
{
  return (!isconst_st(p) && isatom_st(p));
}


void print_st(OBJ* st)
{
  char buf[LINE_L + 1];

  sprint_st(buf, st);
  printf("%s", buf);
}


void sprint_st(char* dest, OBJ *st)
{
  OBJ *argp;
  int n;

  if (st) {
    if (isvar(st->name))
      sprint_var(dest, inlist_var(st->name));
    else {
      sprintf(dest, "%s", st->name);

	 if (n = st->arity) {
	strcat( dest, "(" );
	argp = st->child;
	for (; n; n--) {
	  sprint_st(dest + strlen(dest), argp);
	  strcat( dest, (argp = argp->brother) ? "," : ")");
	}
      }
    }
  }
}


void rename_cl(char *s, char *sout)
{
  char tok[TOK_L + 1];
  TAB *p;

  reset_tab();
  inputp = s;
  sout[0] = '\0';
  while (*(strcpy(tok, mystrtok()))) {   /*  finisce quando tok = "" */
    if (!strcmp(tok, "_"))               /* "_" == variabile non in lista */
      strcat(sout, add_tab(tok));
    else if (isvar(tok)) {          /* e' una variabile */
      if ((p = in_tab(tok)) != NULL)
        strcat(sout, p->priv);
      else
        strcat(sout, add_tab(tok));
    } else
      strcat(sout, tok);

    strcat(sout, " ");
  }
}


void copy_st(OBJ **dest, OBJ *src, int flag)
{
  if (src) {
    (*dest) = alloc_obj();

    strcpy((*dest)->name, src->name);
    (*dest)->arity = src->arity;

    if (src->arity)
      copy_st(&(*dest)->child, src->child, !IGNOREBROTHER);
    else
      (*dest)->child = NULL;

    if ((flag != IGNOREBROTHER) && src->brother)
      copy_st(&(*dest)->brother, src->brother, !IGNOREBROTHER);
    else
      (*dest)->brother = NULL;
  } else
    *dest = NULL;
}


void scan_st(OBJ *st, int flag)
{
  if (isvar(st->name) && ! inlist_var(st->name))
    add_var(st->name);

  if (st->arity)                                /* scorro st */
    scan_st(st->child, !IGNOREBROTHER);

  if ((flag != IGNOREBROTHER) && st->brother)   /* scanna anche i fratelli */
    scan_st(st->brother, !IGNOREBROTHER);
}


void spec_st(OBJ **dest, OBJ *src, int flag)
{
  OBJ *p = src;

  (*dest) = alloc_obj();

  if (isvar(src->name))
    src = getobj(src);

  strcpy((*dest)->name, src->name);
  (*dest)->arity = src->arity;

  if (src->arity)
    spec_st(&(*dest)->child, src->child, !IGNOREBROTHER);
  else
    (*dest)->child = NULL;

  src = p;
  if ((flag != IGNOREBROTHER) && src->brother)
    spec_st(&(*dest)->brother, src->brother, !IGNOREBROTHER);
  else
    (*dest)->brother = NULL;
}


void destroy_st(OBJ *st)
{
  if (st) {
    destroy_st(st->child);
    destroy_st(st->brother);
    free_obj(st);
  }
}


void free_var_st(OBJ *st)
{
  if (isvar(st->name))
    free_var(inlist_var(st->name));

  if (st->arity)                    /* libera le var. di st */
    free_var_st(st->child);

  if (st->brother)                  /* libera le var. dei fratelli */
    free_var_st(st->brother);
}


  /* static functions */

static void dolist(OBJ *that)
{
  char c;
  OBJ *argp;

  strcpy(that->name, mystrtok());

  if (!isatomic()) {
    that->arity = 1;

    that->child = alloc_obj();
    argp = that->child;
    dolist(argp);
    while ((c = *mystrtok()) == ',') {
      that->arity++;
      argp->brother = alloc_obj();
      argp = argp->brother;
      dolist(argp);
    }
    argp->brother = NULL;

    assert(c == ')');
  } else {
    that->arity = 0;
    that->child = NULL;
  }
}


static void reset_tab()
{
  tabp = tab;
}


static TAB *in_tab(char *s)       /*  se s e' nella tabella, ritorna il
                                     puntatore relativo, altrimenti NULL */
{
  TAB *p;

  for (p = tab; ((p < tabp) && (strcmp(s, p->pub))); p++);
  return (p == tabp) ? NULL : p;
}


static char *add_tab(char *s)     /* aggiunge la var. s  e il suo nuovo nome
                                    alla tabella e ritorna il nuovo nome  */
{
  strcpy(tabp->pub, s);
  strcpy(tabp->priv, new_var());
  tabp++;
  assert((tabp - tab) < VAR_N);
  return (tabp - 1)->priv;
}


static int isatomic()
{
  char *tmp = inputp;

  if (*mystrtok() == '(')
    return 0;
  else {
    inputp = tmp;
    return 1;
  }
}

char *mystrtok()
/*
  Legge, dalla stringa puntata da inputp,
  la prima stringa ( token ) compresa tra i
  caratteri di separazione TOK_SEP, e ritorna
  il puntatore alla stringa letta
*/
{
  static char buf[TOK_L];
  char *p;

  p = buf;
  for (; *inputp && (*inputp == TOK_SEP) ; inputp++);
  for (; (*inputp != TOK_SEP) && (*inputp) ; inputp++,p++)
    *p = *inputp;

  *p = '\0';
  buf[NAME_L] = '\0';
//  assert(strlen(buf) < NAME_L);
  return buf;
}
