/*
  struct.h
*/

#ifndef STRUCT_H
#define STRUCT_H

#include <ctype.h>

#define IGNOREBROTHER 0
#define TOK_SEP       ' '
#define NAME_L        10
#define TOK_L         20
#define VAR_N         30        /* numero var. diverse in una clausola */

struct obj_t {
  char name[NAME_L + 1];
  signed char arity;
  struct obj_t *brother,
               *child;
};

typedef struct obj_t OBJ;

struct clause_t {
  OBJ *head, *body;
};

typedef struct clause_t CLAUSE;

#define isvar(p) ((*(p) == '#') || isupper(*(p)))

extern char *inputp;

void  create_cl(char *s, CLAUSE *cl);
void  rename_cl(char *s, char *sout);
void  create_goal(char *s, OBJ *str);
void  create_head(char *s, OBJ *that);
void  destroy_st(OBJ *st);
void  copy_st(OBJ **dest, OBJ *src, int flag);
void  scan_st(OBJ *st, int flag);
void  spec_st(OBJ **dest, OBJ *src, int flag);
void  free_var_st(OBJ *st);
void  print_st(OBJ *str);
void  sprint_st(char *dest, OBJ *str);
int   isconst_st(OBJ *p);
int   isvar_st(OBJ *p);
int   isatom_st(OBJ *p);
OBJ  *alloc_obj( void );
void  free_obj(OBJ *p);
char *mystrtok( void );


#endif
