/*
  unify.c
*/

#include <stdio.h>
#include <string.h>

#include "unify.h"
#include "struct.h"
#include "predef.h"
#include "var.h"

static DB *findon(OBJ *head, CLAUSE *cl, DB *p, DB *start);

int unify(OBJ *goal, OBJ *head)
{
  int n;
  OBJ *argp1, *argp2;

  goal = getobj(goal);
  head = getobj(head);

  if ((isconst_st(goal) && !isatom_st(head)) ||
     (!isatom_st(goal) && isconst_st(head)))
    return 0;

  else if (isconst_st(goal) && isconst_st(head))
    return (!strcmp(goal->name, head->name));

  else if (isvar_st(goal)) {
    link_var(goal, head);
    return 1;

  } else if (isvar_st(head)) {
    link_var(head, goal);
    return 1;

  } else {
    if (!strcmp(goal->name, head->name) &&
       (goal->arity == head->arity)) {
      argp1 = goal->child;
      argp2 = head->child;

      for (n = goal->arity; n; n--) {
        if (!unify(argp1, argp2))
          return 0;
        argp1 = argp1->brother;
        argp2 = argp2->brother;
      }
      return 1;

    } else
      return 0;
  }
}


DB *find_cl(OBJ *head, CLAUSE *cl, DB *p)
{
  DB *r;

  if (ispredef(head->name)) {
    if (p)
      return NULL;
    else {
      cl->body = cl->head = NULL;
      return (DB *)!NULL;
    }
  }

  return (r = findon(head, cl, p, src)) ? r : findon(head, cl, p, rt_src);
}


static DB *findon(OBJ *head, CLAUSE *cl, DB *p, DB *start)
{
  char sout[LINE_L + 1];
  STACK *tmp = mark_var();

  while (p = find_functor(head->name, p, start)) {
    rename_cl(p->line, sout);
    create_cl(sout, cl);

    if (unify(head, cl->head))
      return p;

    destroy_st(cl->head);
    destroy_st(cl->body);
    free_var_st(head);
    release_var(tmp);
  }
  cl->head = cl->body = NULL;
  return NULL;
}
