/*
  var.c
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <stdlib.h>

#include "var.h"
#include "p97.h"

STACK  *var_sp = NULL;

//inline static void hash_free(VAR *p);
void hash_add(VAR *p);
void hash_del(char *p);


OBJ *getobj(OBJ *st)

  /* ritorna il ptr all'ultimo OBJ della lista di istanziazioni di st

     variabile    |   struttura

         X  ----------->  X1
         ^
         |
         v
         X1 ----------->  a( .... )

    In questo caso getobj( X ) ritorna il ptr a a( .... )
  */
{
  VAR *p;
  OBJ *p2;

  if (st && isvar(st->name) && (p = inlist_var(st->name)) && p->value)
    return ( p2 = getobj(p->value) ) ? p2 : p->value;
  else
    return st;
  /* se st non e' NULL, la struttura st riferisce una variabile e la
    variabile esiste gia' nella lista, allora la funzione si richiama
    ricorsivamente sul valore della variabile in lista.
  */
}


void print_goal_var(STACK *p)
{
  while (p) {
    if (((VAR *)p->data)->name[0] != '#') {
      printf("%s = ", ((VAR *)p->data)->name);
      print_var(((VAR *)p->data));
      printf("\n");
    }
    p = p->prev;
  }
}

void print_var(VAR *st)
{
  char buf[LINE_L + 1];

  sprint_var(buf, st);
  printf("%s", buf);
}

void sprint_var(char *dest, VAR *p)
{
  if (p) {
    if (p->value) {
	 if (isvar(p->value->name))
	   sprint_var(dest, inlist_var(p->value->name));
	 else
	   sprint_st(dest, p->value);
    } else
	 strcpy(dest, p->name);
  } else
    strcpy(dest, "<var>");
}


STACK *mark_var()
{
  return var_sp;
}


void release_var(STACK *marked)
{
  while (var_sp != marked) {
    destroy_var((VAR *)var_sp->data);
    pop(&var_sp);
  }
}


void destroy_var(VAR *p)
{
  if (p) {
//    hash_del(p->name);
    if (p->value) {
      assert(p->value->brother == NULL);
      destroy_st(p->value);
    }
  }
}


#define HASH_N  512L
struct {
  VAR *p;
  long n;
} hashv[HASH_N];

#define varno(p) (atol((p) + 1) % HASH_N)


int in_hash = 0, in_list = 0;

VAR *inlist_var(char *varname)
{
  STACK *p;
  long n, n2;

  /*
  if (
    (varname[0] == '#') &&
      (hashv[n = varno(varname)].n == atol(varname + 1))) {
    in_hash++;
    return hashv[n].p;
  }
  */

  in_list++;
  p = var_sp;
  while ((p != NULL) && (strcmp(((VAR *)p->data)->name, varname)))
    p = p->prev;

  return ( p ? (VAR *)p->data : NULL );
}


char *new_var()
{
  static char buf[NAME_L];
  static long var_count = 0L;
  long n;

  assert(var_count < 10000000L);
  sprintf(buf, "#%07ld", var_count++);
  return buf;
}


void link_var(OBJ *stv, OBJ *st)
{
  VAR *v;

  if (!( v = inlist_var(stv->name)) )
    v = add_var( stv->name );

  copy_st( &v->value, st, IGNOREBROTHER ); /* copia ma ignora i fratelli */
  scan_st(st, IGNOREBROTHER);              /* scanna ma ignora i fratelli */
}


VAR *add_var(char *s)
{
  VAR v;

  assert(strlen(s) < NAME_L);
  strcpy(v.name, s);
  v.value = NULL;
  push(&v, sizeof(VAR), &var_sp);
//  hash_add((VAR *)var_sp->data);
  return ((VAR *)var_sp->data);
}


void free_var(VAR *p)
{
  if (p) {
    destroy_st(p->value);
    p->value = NULL;
  }
}

void init_hash()
{
  memset(hashv, 0xff, sizeof(hashv));
}


void hash_add(VAR *p)
{
  long n;

  if (
    (p->name[0] == '#') &&                   /* e' una variabile con numero */
      (hashv[n = varno(p->name)].n == -1)) { /* tab hash e' libera */

    hashv[n].p = p;
    hashv[n].n = n;
  }
}

void hash_del(char *p)
{
  if (p[0] == '#')
    hashv[varno(p)].n = -1;
}